// apps/MiniProjet/main_MiniProjet.cpp

#include<Grapic.h>
#include <stdlib.h>

using namespace grapic;
using namespace std;

//constantes
const int DIMW = 500;
const int MAX_mur = 4;
const int MAX_balle = 4;
const int PV = 500;
const int PVBOSS = 1000;
const int t_mur = 210;
const int tboss = 40;
const int MAX_tir = 100;
const float dt = 0.1f;
const float g = 9.81f;

//pr-utilisations
struct Color{
    int r,g,b;
};
void initColor(Color &C, int r, int g, int b)
{
    C.r = r;
    C.g = g;
    C.b = b;
}
Color make_color(int r, int g, int b)
{
    Color C;
    C.r = r;
    C.g = g;
    C.b = b;
    return C;
}
Color operator+(Color a, Color b)
{
    Color c;
    initColor(c, (a.r+b.r),(a.g+b.g),(a.b+b.b));
    return c;
}
Color operator*(float a, Color b)
{
    Color c;
    initColor(c, (a*b.r), (a*b.g), (a*b.b));
    return c;
}
Color operator-(Color a, Color b)
{
    Color c;
    initColor(c, (a.r-b.r),(a.g-b.g),(a.b-b.b));
    return c;
}
Color operator/(Color a, float b)
{
    Color c;
    initColor(c, (a.r/b),(a.g/b),(a.b/b));
    return c;
}
//color ok, aura t utile prcdemment
struct Complex
{
    float x,y;
};
Complex make_Complex(float x, float y)
{
    Complex c;
    c.x = x;
    c.y = y;
    return c;
}
Complex operator+(Complex a, Complex b)
{
    return make_Complex(a.x+b.x, a.y+b.y);
}
Complex operator-(Complex a, Complex b)
{
    return make_Complex(a.x-b.x, a.y-b.y);
}
Complex operator*(float a, Complex b)
{
    return make_Complex(a*b.x, a*b.y);
}
struct Vec
{
    float x,y;
};
Vec make_vec(float x, float y)
{
    Vec c;
    c.x = x;
    c.y = y;
    return c;
}

Vec operator+(Vec a, Vec b)
{
    return make_vec(a.x+b.x, a.y+b.y);
}
Vec operator-(Vec a, Vec b)
{
    return make_vec(a.x-b.x, a.y-b.y);
}
Vec operator*(float a, Vec b)
{
    return make_vec(a*b.x, a*b.y);
}
//Complex,vec ok

//structures
struct Alien //notre personnage dynamique
{
    Image al;
    Vec position;
    Color couleur;
    int pv; //barre de vie
};
struct Tir //tir : dynamique
{
    Vec position;
    Color couleur;
    int visible;
};
struct Mur //obstacle : mur dynamique
{
    Vec position;
    Color couleur;
    Vec deplacement;
};
struct Boss //boss du mini-jeu  liminer
{
    Image boo;
    Vec pos;
    Color coul;
    int pv_b;
    int compt;
    int sens; //sera somm  sa position x (pour simplifier par rapport aux vecteurs)
};
struct Balle //reprise d'une particule
{
    Vec position;
    Vec vitesse;
    float masse;
    Vec force;
    int visible;
    int qd_visible; //quand la balle sera visible, ainsi il n'apparait pas de balle ds le dbut du jeu
};
struct Monde //structure regroupant tout !
{
    Image bg;
    Alien A;
    Mur tab_mur[MAX_mur];
    Boss B;
    Balle tab_balle[MAX_balle];
    Tir tab_tir[MAX_tir];
    int nb_balle;
    int nb_mur;
    int nb_de_tir;
    int compteur_tir;
    int compteur_balle;
    Image imfingagne = image("data/jjj/gagne.png");
    Image infinperdu = image("data/jjj/game_over.jpg");
    Image missile = image("data/jjj/missile.png");
    Image start2 = image("data/jjj/start2.png");
    Image exit2 = image("data/jjj/exit2.png");
    Image balls = image("data/jjj/ball_px.png");
};
//fonctions
Alien make_alien(float x, float y, int r, int g, int b, int pv)
{
    Alien Al;
    Al.al = image("data/jjj/alien.png");
    Al.position.x = x;
    Al.position.y = y;
    Al.couleur.r = r;
    Al.couleur.g = g;
    Al.couleur.b = b;
    Al.pv = pv;
    return Al;
}
Boss make_boss(float x, float y, int pv)
{
    Boss Bo;
    Bo.boo = image("data/jjj/boo.png");
    Bo.pos.x = x;
    Bo.pos.y = y;
    Bo.pv_b = pv;
    Bo.coul.r = 120;
    Bo.coul.g = 70;
    Bo.coul.b = 200;
    Bo.compt = 0;
    Bo.sens = 1; //de base bouge lentement
    return Bo;
}
Balle make_balle(float m, Vec pos, Vec vit)
{
    Balle B;
    B.force = make_vec(0,0);
    B.position = pos;
    B.masse = m;
    B.vitesse = vit;
    return B;
}
Mur make_mur(Vec pos, int r, int g, int b, Vec vit)
{
    Mur M;
    M.position = pos;
    M.couleur.r = r;
    M.couleur.g = g;
    M.couleur.b = b;
    M.deplacement = vit;
    return M;
}

void initMonde(Monde &m, int nb_balle, int nb_mur)
{
    m.A = make_alien(30, DIMW/2, rand()%255, rand()%255, rand()%255, PV);
    m.B = make_boss(DIMW-tboss-10, DIMW/2, PVBOSS);
    m.nb_balle = nb_balle;
    m.nb_mur = nb_mur;
    int i;
    for(i=0; i<nb_balle; i++)
    {
        m.tab_balle[i] = make_balle(1, make_vec(m.B.pos.x-tboss-10,m.B.pos.y), make_vec(frand(-50.f,50.f),frand(-50.f,50.f)));
        m.tab_balle[i].visible = 0;
        m.tab_balle[i].qd_visible = rand()%99 + 1;
    }
    for(i=0; i<nb_mur; i++)
    {
        if(i%2==0)
        {
            m.tab_mur[i] = make_mur(make_vec(rand()%450 + 50, 0), 255, 0, 0, make_vec(5,0));
        }
        else
        {
            m.tab_mur[i] = make_mur(make_vec(rand()%450 + 50, DIMW-t_mur), 255, 0, 0, make_vec(5,0));
        }
    }
    for(i=0; i<MAX_tir; i++)
    {
        m.tab_tir[i].visible = 0;
        m.tab_tir[i].couleur = make_color(200,100,0);
    }
    m.nb_de_tir=0;
    m.compteur_tir=0;
    m.bg = image("data/jjj/bg_game.jpg");
}

void PartAdd(Balle &b, Vec f)
{
    b.force = b.force + f;
}

void drawMonde(Monde m)
{
    image_draw(m.bg,0,0,DIMW,DIMW);
    image_draw(m.A.al,m.A.position.x-DIMW/25, m.A.position.y-DIMW/25, 40, 40);
    image_draw(m.B.boo, m.B.pos.x-tboss/2, m.B.pos.y-tboss/2, tboss*2, tboss*2);
    int i,j,k;
    for(i=0; i<m.nb_mur; i++)
    {
        color(m.tab_mur[i].couleur.r, m.tab_mur[i].couleur.g, m.tab_mur[i].couleur.b);
        rectangleFill(m.tab_mur[i].position.x, m.tab_mur[i].position.y, m.tab_mur[i].position.x+40, m.tab_mur[i].position.y+t_mur);
    }
    for(j=0; j<m.nb_balle; j++)
    {
        if(m.tab_balle[j].visible == 1)
        {
            color(255, 0, 0);
            image_draw(m.balls, m.tab_balle[j].position.x-DIMW/50, m.tab_balle[j].position.y-DIMW/50, DIMW/25, DIMW/25);
        }
    }
    for(k=0; k<MAX_tir; k++)
    {
        if(m.tab_tir[k].visible==1)
        {
            image_draw(m.missile, m.tab_tir[k].position.x, m.tab_tir[k].position.y, 10, 10, 45);
        }
    }
    color(0,200,0);
    fontSize(16);
    print(10, DIMW-30, "PV Alien");
    float PVa = PV;
    float PVactuelalien = m.A.pv;
    rectangleFill(7,DIMW-45,7+(PVactuelalien/PVa)*80.0, DIMW-35);
    color(200,0,0);
    print(DIMW-90, DIMW-30, "PV Boss");
    float PVb = PVBOSS;
    float PVactuelboss = m.B.pv_b;
    rectangleFill(DIMW-95,DIMW-45,DIMW-95+(PVactuelboss/PVb)*80.0, DIMW-35);
    color(0,0,0);
    rectangle(7,DIMW-45,87,DIMW-35);
    rectangle(DIMW-95,DIMW-45,DIMW-15,DIMW-35);
}

void update(Monde &m)
{

    for(int l=0; l<m.nb_balle; l++)
    {
        if(m.tab_balle[l].visible == 1)
        {
            m.tab_balle[l].vitesse = m.tab_balle[l].vitesse + (1.0/m.tab_balle[l].masse)*dt*m.tab_balle[l].force; //modifier sa vitesse et par consquent change la diffrence de positions de la particule
            m.tab_balle[l].position = m.tab_balle[l].position + dt*m.tab_balle[l].vitesse;
            m.tab_balle[l].force = make_vec(0, -m.tab_balle[l].masse*g); //change la force avec la grav
            if(m.tab_balle[l].position.y<=0)
            {
                m.tab_balle[l].position.y = -m.tab_balle[l].position.y;
                m.tab_balle[l].vitesse.y = -1.1*m.tab_balle[l].vitesse.y;
            }
            if(m.tab_balle[l].position.x>DIMW)
            {
                m.tab_balle[l].position.x = 2*DIMW - m.tab_balle[l].position.x;
                m.tab_balle[l].vitesse.x = -m.tab_balle[l].vitesse.x;
            }
            if(m.tab_balle[l].position.x<0)
            {
                m.tab_balle[l].position.x = -m.tab_balle[l].position.x;
                m.tab_balle[l].vitesse.x = -m.tab_balle[l].vitesse.x;
            }
            if(m.tab_balle[l].position.y>DIMW)
            {
                m.tab_balle[l].position.y = 2*DIMW - m.tab_balle[l].position.y;
                m.tab_balle[l].vitesse.y = -1.1*m.tab_balle[l].vitesse.y;
            }
            if(m.tab_balle[l].vitesse.x<-500 || m.tab_balle[l].vitesse.x>500)
            {
                m.tab_balle[l].vitesse.x = 100;
            }
            if(m.tab_balle[l].vitesse.y<-500 || m.tab_balle[l].vitesse.y>500)
            {
                m.tab_balle[l].vitesse.y = 100;
            }
        }else{
            if(m.compteur_balle == m.tab_balle[l].qd_visible)
            {
                m.tab_balle[l].visible = 1;
                m.tab_balle[l].position = m.B.pos;
            }
        }
    }
    if(m.compteur_balle > 1000)
    {
        m.compteur_balle = 0;
        for(int o=0; o<m.nb_balle; o++)
        {
            m.tab_balle[o].visible = 0;
            m.tab_balle[o].qd_visible = rand()%99 + 1;
        }
    }
    if(m.B.pos.y<DIMW-tboss && m.B.pos.y>tboss)
    {
        m.B.pos.y = m.B.pos.y+m.B.sens;
    }
    else
    {
        if(m.B.pos.y>DIMW-tboss)
        {
            m.B.sens=(rand()%5 +1)*(-1);
        }
        else
        {
            m.B.sens=(rand()%5 +1);
        }
        m.B.pos.y = m.B.pos.y+m.B.sens;
    }
    int i;
    for(i=0; i<m.nb_mur; i++)
    {
        if(m.tab_mur[i].position.x > DIMW-50-tboss*2)
        {
            m.tab_mur[i].deplacement.x = (rand()%5 +5)*(-1);
        }
        if(m.tab_mur[i].position.x < 0)
        {
            m.tab_mur[i].deplacement.x = (rand()%5 +5);
        }
        //cout<<m.tab_mur[i].deplacement.x<<" "<<m.tab_mur[i].deplacement.y<<endl;
        m.tab_mur[i].position = m.tab_mur[i].position + m.tab_mur[i].deplacement;
    }
    int k;
    for(k=0; k<MAX_tir; k++)
    {
        if(m.tab_tir[k].visible == 1)
        {
            m.tab_tir[k].position.x = m.tab_tir[k].position.x + 5;
        }
        if(m.tab_tir[k].position.x > DIMW)
        {
            m.tab_tir[k].visible = 0;
        }
    }
    setKeyRepeatMode(true);
    if(isKeyPressed(SDLK_UP))
    {
        if(m.A.position.y < DIMW-(DIMW/25))
        {
            m.A.position.y = m.A.position.y + 6;
        }
    }
    if(isKeyPressed(SDLK_DOWN))
    {
        if(m.A.position.y > (DIMW/25))
        {
            m.A.position.y = m.A.position.y - 6;
        }
    }
    if(isKeyPressed(SDLK_RIGHT))
    {
        if(m.A.position.x < DIMW-(DIMW/25))
        {
            m.A.position.x = m.A.position.x + 6;
        }
    }
    if(isKeyPressed(SDLK_LEFT))
    {
        if(m.A.position.x > (DIMW/25))
        {
            m.A.position.x = m.A.position.x - 6;
        }
    }
    if(isKeyPressed(SDLK_t))
    {
        if(m.nb_de_tir<MAX_tir && m.compteur_tir>15)
        {
            m.tab_tir[m.nb_de_tir].visible = 1;
            m.tab_tir[m.nb_de_tir].position = m.A.position;
            m.tab_tir[m.nb_de_tir].position.x = m.tab_tir[m.nb_de_tir].position.x+DIMW/25;
            m.nb_de_tir = m.nb_de_tir + 1;
            m.compteur_tir = 0;
        }
    }
    m.compteur_tir = m.compteur_tir + 1;
    m.compteur_balle = m.compteur_balle + 1;
}

bool distance_alien_boss(Alien A, Boss B)
{
    Vec ab = B.pos-A.position;
    return sqrt(ab.x*ab.x+ab.y*ab.y)<DIMW/25+tboss;
}
bool distance_alien_balle(Alien A, Balle B)
{
    Vec ab = B.position-A.position;
    return sqrt(ab.x*ab.x+ab.y*ab.y)<DIMW/25+DIMW/50;
}
bool distance_tir_boss(Boss B, Tir T)
{
    Vec ab = B.pos-T.position;
    return sqrt(ab.x*ab.x+ab.y*ab.y)<5+tboss;
}

void collision(Monde &m)
{
    int i;
    for(i=0; i<m.nb_mur; i++)
    {
        if(m.A.position.x > m.tab_mur[i].position.x && m.A.position.x < m.tab_mur[i].position.x+40 && m.A.position.y > m.tab_mur[i].position.y && m.A.position.y < m.tab_mur[i].position.y+t_mur)
        {
            m.A.pv = m.A.pv-20;
        }
    }
    if(distance_alien_boss(m.A, m.B))
    {
        m.A.pv = 0;
    }
    int j;
    for(j=0; j<m.nb_balle; j++)
    {
        if(distance_alien_balle(m.A, m.tab_balle[j]))
        {
            m.A.pv = m.A.pv-5;
        }
    }
    int k;
    for(k=0; k<m.nb_de_tir; k++)
    {
        if(distance_tir_boss(m.B, m.tab_tir[k]) && m.tab_tir[k].visible == 1)
        {
            m.B.pv_b = m.B.pv_b - 50;
            m.tab_tir[k].visible = 0;
        }
    }
}

bool joue_encore(Monde m)
{
    return (m.A.pv>0 && m.B.pv_b>0);
}

void drawfin(Monde &m, bool &alors)
{
    if(m.A.pv>0)
    {
        image_draw(m.imfingagne, -50, 0, DIMW+100, DIMW);
        color(255,255,255);
        rectangleFill(DIMW/2-135,DIMW/2-100, DIMW/2+135,DIMW/2-70);
        color(0,0,0);
        fontSize(20);
        print(DIMW/2-125, DIMW/2-100, "VEUX-TU RECOMMENCER ?");
        image_draw(m.start2, DIMW/2-180, DIMW/2-165, 120, 45);
        image_draw(m.exit2, DIMW/2+50, DIMW/2-165, 120, 45);
        int x,y;
        if(isMousePressed(SDL_BUTTON_LEFT))
        {
            mousePos(x,y);
            if(x>DIMW/2-180 && x<DIMW/2-180+120 && y>DIMW/2-165 && y<DIMW/2-165+45)
            {
                initMonde(m, 2, 2);
            }
            if(x>DIMW/2+50 && x<DIMW/2+50+120 && y>DIMW/2-165 && y<DIMW/2-165+45)
            {
                alors = false;
                initMonde(m, 2, 2);
            }
        }
    }
    else
    {
        image_draw(m.infinperdu, 0, 0, DIMW, DIMW);
        color(255,255,255);
        rectangleFill(DIMW/2-135,DIMW/2-100, DIMW/2+135,DIMW/2-70);
        color(0,0,0);
        fontSize(20);
        print(DIMW/2-125, DIMW/2-100, "VEUX-TU RECOMMENCER ?");
        image_draw(m.start2, DIMW/2-180, DIMW/2-165, 120, 45);
        image_draw(m.exit2, DIMW/2+50, DIMW/2-165, 120, 45);
        int x,y;
        if(isMousePressed(SDL_BUTTON_LEFT))
        {
            mousePos(x,y);
            if(x>DIMW/2-180 && x<DIMW/2-180+120 && y>DIMW/2-165 && y<DIMW/2-165+45)
            {
                initMonde(m, 2, 2);
            }
            if(x>DIMW/2+50 && x<DIMW/2+50+120 && y>DIMW/2-165 && y<DIMW/2-165+45)
            {
                alors = false;
                initMonde(m, 2, 2);
            }
        }
    }
}

struct menuu
{
    Image im = image("data/jjj/start.png"); // modifier l'endoit o est la photo en fonction de l o elle est dpose
    Image haut = image("data/jjj/haut.png");
    Image bas = image("data/jjj/bas.png");
    Image gauche = image("data/jjj/gauche.png");
    Image droite = image("data/jjj/droite.png");
    Image hautv = image("data/jjj/haut-v.jpg");
    Image basv = image("data/jjj/bas-v.jpg");
    Image droitev = image("data/jjj/droite-v.jpg");
    Image gauchev = image("data/jjj/gauche-v.jpg");
    Image t = image("data/jjj/t.png");
    Image tv = image("data/jjj/tv.png");
    Image regles = image("data/jjj/police.png");
    Image arrow = image("data/jjj/arrow_red.png");
};

void drawmenu(menuu m)
{
    image_draw(m.regles,0,DIMW-80,DIMW,80);
    image_draw(m.arrow,100,DIMW-180,100,50,45);
    image_draw(m.arrow,DIMW-200,DIMW-180,100,50,-45,true);
    fontSize(14);
    print(DIMW/2,DIMW/8*2,"ICI, TU PEUX TESTER TES TOUCHES !");
    print(DIMW/2,DIMW/8*2-20,"T -> pour tirer des missiles");
    print(DIMW/2,DIMW/8*2-40,"Les flches -> pour te dplacer");
    image_draw(m.im, DIMW/2-60, DIMW/2, 2.53*50, 50);
    image_draw(m.haut, DIMW/8*2-50, DIMW/8*2-50, DIMW/8, DIMW/8);
    image_draw(m.bas, DIMW/8*2-50, DIMW/8-50, DIMW/8, DIMW/8);
    image_draw(m.gauche, DIMW/8-50, DIMW/8-50, DIMW/8, DIMW/8);
    image_draw(m.droite, DIMW/8*3-50, DIMW/8-50, DIMW/8, DIMW/8);
    image_draw(m.t, DIMW/8*3-35, DIMW/8*2-35, DIMW/8, DIMW/8);
    setKeyRepeatMode(true);
    if(isKeyPressed(SDLK_UP))
    {
        image_draw(m.hautv, DIMW/8*2-50, DIMW/8*2-50, DIMW/8, DIMW/8);
    }
    if(isKeyPressed(SDLK_DOWN))
    {
        image_draw(m.basv, DIMW/8*2-50, DIMW/8-50, DIMW/8, DIMW/8);
    }
    if(isKeyPressed(SDLK_LEFT))
    {
        image_draw(m.gauchev, DIMW/8-50, DIMW/8-50, DIMW/8-1, DIMW/8-1);
    }
    if(isKeyPressed(SDLK_RIGHT))
    {
        image_draw(m.droitev, DIMW/8*3-50, DIMW/8-50, DIMW/8, DIMW/8);
    }
    if(isKeyPressed(SDLK_t))
    {
        image_draw(m.tv, DIMW/8*3-35, DIMW/8*2-35, DIMW/8, DIMW/8);
    }
}

void lancementjeu(bool &alors)
{
    int x,y;
    if(isMousePressed(SDL_BUTTON_LEFT))
    {
        mousePos(x,y);
        if(x>DIMW/2-60 && y>DIMW/2 && x<DIMW/2-60+2.53*50 && y<DIMW/2+50)
        {
            alors = true;
        }
    }
}

//main
int main(int , char**)
{
	winInit("Mini-Projet",DIMW,DIMW);
	winClear();
	menuu M;
	bool la = false;
	Monde World;
	initMonde(World, 2, 2);
	bool stop = false;
	while(!stop)
    {
        winClear();
        if(la == false)
        {
            drawmenu(M);
            lancementjeu(la);
        }
        else{
            if(joue_encore(World))
            {
                delay(20);
                update(World);
                collision(World);
                drawMonde(World);
            }
            else
            {
                drawfin(World, la);
            }
        }
        stop = winDisplay();
    }
	winQuit();
	return 0;
}

